﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment
{

    //get appointment AND Service activity
    public class GetAppointmentStep : FilterBase<MakeGroupAppointmentStateObject>
    {
        public override void Execute(MakeGroupAppointmentStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {

                state.CrmAppointment = srv.AppointmentSet.FirstOrDefault(a => a.Id == state.AppointmentId);
                if (state.CrmAppointment != null)
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(sa => sa.Id == state.CrmAppointment.cvt_serviceactivityid.Id);
                }
                else
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
                }
            }
            if (state.CrmAppointment == null) throw new Exception("Group Appointment cannot be null");
        }
    }
}
